//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;

import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;

/**
 * Complete code for Example 2-1 in Chapter 2, Understanding OLAP API Metadata,
 * in the Oracle OLAP Developer's Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class GettingDataTypeOfMdmSource
{
  public GettingDataTypeOfMdmSource()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();

    // Get the MdmPrimaryDimension for the Global schema dimension of product
    // values.
    MdmPrimaryDimension mdmProdDim =
                             context.getMdmPrimaryDimensionByName("PRODUCT");

    context.println("Example 2-1, Getting the Data Type of an MdmSource\n");

    String myDataType = getDataType(dp, mdmProdDim);

    context.println("The data type of " + mdmProdDim.getName() +
                     " is " + myDataType + ".");
  }

  public String getDataType(DataProvider dp, MdmSource metaSource)
  {
    String theDataType = null;

    FundamentalMetadataProvider fmp =
        dp.getFundamentalMetadataProvider();

    if (fmp.getBooleanDataType() == metaSource.getDataType())
       theDataType = "Boolean";
    else if (fmp.getDateDataType() == metaSource.getDataType())
       theDataType = "Date";
    else if (fmp.getDoubleDataType() == metaSource.getDataType())
       theDataType = "Double";
    else if (fmp.getFloatDataType() == metaSource.getDataType())
       theDataType = "Float";
    else if (fmp.getIntegerDataType() == metaSource.getDataType())
       theDataType = "Integer";
    else if (fmp.getShortDataType() == metaSource.getDataType())
       theDataType = "Short";
    else if (fmp.getStringDataType() == metaSource.getDataType())
       theDataType = "String";
    else if (fmp.getNumberDataType() == metaSource.getDataType())
       theDataType = "Number";
    else if (fmp.getValueDataType() == metaSource.getDataType())
       theDataType = "Value";

    return theDataType;
  }

  public static void main(String[] args)
  {
    new GettingDataTypeOfMdmSource().run(args);
  }
}
